
/* targets: none, about window, log file, modal dialog, debugger */

#define LAND_LOGTARGET_NONE			0
#define LAND_LOGTARGET_ABOUT		1
#define LAND_LOGTARGET_FILE			2
#define LAND_LOGTARGET_DIALOG		4
#define LAND_LOGTARGET_DEBUGGER		8


/* levels: off, everything, medium, low */

#define LAND_LOGLEVEL_OFF	0
#define LAND_LOGLEVEL_1		1
#define LAND_LOGLEVEL_2		2
#define LAND_LOGLEVEL_3		3


/* configuration for categories */

#define LAND_TCPLOG_NAME	"tcp"
#define LAND_TCPLOG_LEVEL	LAND_LOGLEVEL_OFF
#define LAND_TCPLOG_TARGET	LAND_LOGTARGET_NONE

#define LAND_DBLOG_NAME		"db"
#define LAND_DBLOG_LEVEL	LAND_LOGLEVEL_OFF
#define LAND_DBLOG_TARGET	LAND_LOGTARGET_NONE

#define LAND_THREADSLOG_NAME		"threads"
#define LAND_THREADSLOG_LEVEL		LAND_LOGLEVEL_OFF
#define LAND_THREADSLOG_TARGET		LAND_LOGTARGET_NONE

#define LAND_GENERALLOG_NAME		"general"
#define LAND_GENERALLOG_LEVEL		LAND_LOGLEVEL_OFF
#define LAND_GENERALLOG_TARGET		LAND_LOGTARGET_NONE


/* basic definitions */

#define LAND_MSG(m, t, n)		logmessage ((m), __FILE__, __LINE__, (t), (n))
#define LAND_ASSERT(e, t, n)	((void) ((e) ? 0 : (logassert ((#e), __FILE__, __LINE__, (t), (n))))


/* definitions for GENERAL category */

#if (LAND_GENERALLOG_LEVEL >= LAND_LOGLEVEL_1)
	#define MSG_1(x)		LAND_MSG((x), LAND_GENERALLOG_TARGET, LAND_GENERALLOG_NAME)
	#define ASSERT_1(x)		LAND_ASSERT((x), LAND_GENERALLOG_TARGET, LAND_GENERALLOG_NAME))
#else
	#define MSG_1(x)		((void *) nil)
	#define ASSERT_1(x)		((void *) nil)
#endif

#if (LAND_GENERALLOG_LEVEL >= LAND_LOGLEVEL_2)
	#define MSG_2(x)		LAND_MSG((x), LAND_GENERALLOG_TARGET, LAND_GENERALLOG_NAME)
	#define ASSERT_2(x)		LAND_ASSERT((x), LAND_GENERALLOG_TARGET, LAND_GENERALLOG_NAME))
#else
	#define MSG_2(x)		((void *) nil)
	#define ASSERT_2(x)		((void *) nil)
#endif

#if (LAND_GENERALLOG_LEVEL >= LAND_LOGLEVEL_3)
	#define MSG_3(x)		LAND_MSG((x), LAND_GENERALLOG_TARGET, LAND_GENERALLOG_NAME)
	#define ASSERT_3(x)		LAND_ASSERT((x), LAND_GENERALLOG_TARGET, LAND_GENERALLOG_NAME))
#else
	#define MSG_3(x)		((void *) nil)
	#define ASSERT_3(x)		((void *) nil)
#endif


/* definitions for TCP category */

#if (LAND_TCPLOG_LEVEL >= LAND_LOGLEVEL_1)
	#define TCP_MSG_1(x)		LAND_MSG((x), LAND_TCPLOG_TARGET, LAND_TCPLOG_NAME)
	#define TCP_ASSERT_1(x)		LAND_ASSERT((x), LAND_TCPLOG_TARGET, LAND_TCPLOG_NAME))
#else
	#define TCP_MSG_1(x)		((void *) nil)
	#define TCP_ASSERT_1(x)		((void *) nil)
#endif

#if (LAND_TCPLOG_LEVEL >= LAND_LOGLEVEL_2)
	#define TCP_MSG_2(x)		LAND_MSG((x), LAND_TCPLOG_TARGET, LAND_TCPLOG_NAME)
	#define TCP_ASSERT_2(x)		LAND_ASSERT((x), LAND_TCPLOG_TARGET, LAND_TCPLOG_NAME))
#else
	#define TCP_MSG_2(x)		((void *) nil)
	#define TCP_ASSERT_2(x)		((void *) nil)
#endif

#if (LAND_TCPLOG_LEVEL >= LAND_LOGLEVEL_3)
	#define TCP_MSG_3(x)		LAND_MSG((x), LAND_TCPLOG_TARGET, LAND_TCPLOG_NAME)
	#define TCP_ASSERT_3(x)		LAND_ASSERT((x), LAND_TCPLOG_TARGET, LAND_TCPLOG_NAME))
#else
	#define TCP_MSG_3(x)		((void *) nil)
	#define TCP_ASSERT_3(x)		((void *) nil)
#endif


/* definitions for DB category */

#if (LAND_DBLOG_LEVEL >= LAND_LOGLEVEL_1)
	#define DB_MSG_1(x)		LAND_MSG((x), LAND_DBLOG_TARGET, LAND_DBLOG_NAME)
	#define DB_ASSERT_1(x)		LAND_ASSERT((x), LAND_DBLOG_TARGET, LAND_DBLOG_NAME))
#else
	#define DB_MSG_1(x)		((void *) nil)
	#define DB_ASSERT_1(x)		((void *) nil)
#endif

#if (LAND_DBLOG_LEVEL >= LAND_LOGLEVEL_2)
	#define DB_MSG_2(x)		LAND_MSG((x), LAND_DBLOG_TARGET, LAND_DBLOG_NAME)
	#define DB_ASSERT_2(x)		LAND_ASSERT((x), LAND_DBLOG_TARGET, LAND_DBLOG_NAME))
#else
	#define DB_MSG_2(x)		((void *) nil)
	#define DB_ASSERT_2(x)		((void *) nil)
#endif

#if (LAND_DBLOG_LEVEL >= LAND_LOGLEVEL_3)
	#define DB_MSG_3(x)		LAND_MSG((x), LAND_DBLOG_TARGET, LAND_DBLOG_NAME)
	#define DB_ASSERT_3(x)		LAND_ASSERT((x), LAND_DBLOG_TARGET, LAND_DBLOG_NAME))
#else
	#define DB_MSG_3(x)		((void *) nil)
	#define DB_ASSERT_3(x)		((void *) nil)
#endif


/* definitions for THREADS category */

#if (LAND_THREADSLOG_LEVEL >= LAND_LOGLEVEL_1)
	#define THREADS_MSG_1(x)		LAND_MSG((x), LAND_THREADSLOG_TARGET, LAND_THREADSLOG_NAME)
	#define THREADS_ASSERT_1(x)		LAND_ASSERT((x), LAND_THREADSLOG_TARGET, LAND_THREADSLOG_NAME))
#else
	#define THREADS_MSG_1(x)		((void *) nil)
	#define THREADS_ASSERT_1(x)		((void *) nil)
#endif

#if (LAND_THREADSLOG_LEVEL >= LAND_LOGLEVEL_2)
	#define THREADS_MSG_2(x)		LAND_MSG((x), LAND_THREADSLOG_TARGET, LAND_THREADSLOG_NAME)
	#define THREADS_ASSERT_2(x)		LAND_ASSERT((x), LAND_THREADSLOG_TARGET, LAND_THREADSLOG_NAME))
#else
	#define THREADS_MSG_2(x)		((void *) nil)
	#define THREADS_ASSERT_2(x)		((void *) nil)
#endif

#if (LAND_THREADSLOG_LEVEL >= LAND_LOGLEVEL_3)
	#define THREADS_MSG_3(x)		LAND_MSG((x), LAND_THREADSLOG_TARGET, LAND_THREADSLOG_NAME)
	#define THREADS_ASSERT_3(x)		LAND_ASSERT((x), LAND_THREADSLOG_TARGET, LAND_THREADSLOG_NAME))
#else
	#define THREADS_MSG_3(x)		((void *) nil)
	#define THREADS_ASSERT_3(x)		((void *) nil)
#endif


/* function templates */

extern void logmessage (char *, char *, long, long, char *);

extern long logassert (char *, char *, long, long, char *);

extern void logstartup (void);

extern void logshutdown (void);

